/* Matthew C Mahutga, Michaela Curran, and Anthony Roberts
   matthew.mahutga@ucr.edu
   Job Tasks and the Comparative Structure of Income and Employment: Routine Task Intensity and Offshorability for the LIS
   International Journal of Comparative Sociology 2018
   
   Description: This script provides guidance for merging the RTI and OFFS dataset in with LIS data. 
   Users must first request that LIS upload the file to their user folder. Steps are provided below.
   Date Modified: February 5, 2018 */

/* Step 1: Send the RTI / OFFS dataset as an attachment (zipped file) to LIS via email at usersupport@lisdatacenter.org. 
   Please note: LIS must review the file before uploading it to their server. This may take time.
   After your file is accepted, LIS will send you a LISSY address for it. 
   The address will follow this format: $mydata/mcurra/lis_external_merge.dta (where mcurra is the user's name for LISSY and lis_external_merge.dta is the name of the uploaded file) 
   You are able to access the uploaded file in LISSY in .dta format with this address 
   Please adjust the file path to this address where noted with [adjust file path] */

/* Step 2: Log into LISSY and append the relevant datasets using Stata code like in the example below.
   This example will append all country-years for which there are available RTI and OFFS scores.
   Note: This may take awhile because it contains many records. You can always append and merge sections at time and save to your user file, if needed.
   To save to your user file: save $mydata/mcurra/append1.dta, replace */
   
use $au81p, clear

keep dname cname year

foreach file in $at95p $at04p $at07p $at10p $at13p{ 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $be95p $be97p $be00p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $br06p $br09p $br11p $br13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $ca94p $ca97p $ca98p $ca00p $ca04p $ca07p $ca10p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $co04p $co07p $co10p $co13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $cz92p $cz96p $cz02p $cz04p $cz07p $cz10p $cz13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $dk92p $dk04p $dk07p $dk10p $dk13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $do07p { 
	quietly: append using `file', keep(dname cname year)
} 

foreach file in $eg12p { 
	quietly: append using `file', keep(dname cname year)
} 

foreach file in $ee00p $ee07p $ee10p $ee13p { 
	quietly: append using `file', keep(dname cname year)
} 

foreach file in $fi87p $fi91p $fi95p $fi00p $fi04p $fi07p $fi10p $fi13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $fr78p $fr84p $fr89p $fr94p $fr00p $fr05p $fr10p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $ge10p $ge13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $de84p $de89p $de94p $de00p $de04p $de07p $de10p $de13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $gr04p $gr07p $gr10p $gr13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $gt06p $gt11p $gt14p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $hu91p $hu94p $hu99p $hu05p $hu07p $hu09p $hu12p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $is04p $is07p $is10p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $in04p $in11p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $ie87p $ie94p $ie95p $ie96p $ie00p $ie04p $ie07p $ie10p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $il07p $il10p $il12p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $lt10p $lt13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $lu97p $lu00p $lu04p $lu07p $lu10p $lu13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $mx08p $mx10p $mx12p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $nl90p $nl93p $nl99p $nl04p $nl07p $nl10p $nl13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $pa07p $pa10p $pa13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $pe04p $pe07p $pe10p $pe13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $pl99p $pl04p $pl07p $pl10p $pl13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $ro95p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $ru00p $ru04p $ru07p $ru10p $ru13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $rs06p $rs10p $rs13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $sk92p $sk04p $sk07p $sk10p $sk13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $si97p $si99p $si04p $si07p $si10p $si12p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $es80p $es90p $es95p $es00p $es04p $es07p $es10p $es13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $ch92p $ch00p $ch02p $ch07p $ch10p $ch13p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $uk91p { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $us74p $us79p $us86p $us91p $us94p $us97p $us00p $us04p $us07p $us10p $us13p  { 
	quietly: append using `file', keep(dname cname year)
}

foreach file in $uy04p $uy07p $uy10p $uy13p $uy16p { 
	quietly: append using `file', keep(dname cname year)
}

/* Step 3: Merge the appended files to the external file that contains the RTI and OFFS scores
   Paste this code in the same script in LISSY as the append statements.
   Note: This may take awhile because it contains many records. You can always append and merge sections at time and save to your user file, if needed.
   To save to your user file: save $mydata/mcurra/append1.dta, replace */
   
merge m:1 dname occ1_c using $mydata/mcurra/lis_external_merge.dta // [adjust file path]

/* Step 4: Check the _merge variable. One entry in the RTI/OFFS file for US91 will fail to merge as it is a zero code in the LIS data.
   Two entries from Germany 2010, occ1_c codes 8262 and 9111 will fail to merge because they no longer exist in LIS data. 
   Paste this code in the same script in LISSY as the append and merge statements.
   If you plan on doing other analyses besides those using RTI/OFFS, drop if _merge==2
   If you plan on doing analyses using RTI/OFFS variables in every analysis, keep if _merge==3 
   Note: if you do not plan to append all available country-years in the RTI/OFFS file, you will have some country-years that you do not use that will not merge.
   Check your merge to ensure all the country-years you appended merged, and then drop the remainder that were not appended with drop if _merge==2 
   Also, if you wish to tabulate the occ1_c variable, you will want to take it back to a string format */
   
drop if _merge==2
rename _merge rtioffsmerge

tostring occ1_c, replace

save $mydata/mcurra/rti_offs_merge.dta, replace // [adjust file path]

/* Step 5: You can now access the merged RTI and OFFS dataset by a use statement in LISSY like below */
use $mydata/mcurra/rti_offs_merge.dta // [adjust file path]

exit
